﻿package 
{
	import flash.display.Sprite;
	import flash.display.LoaderInfo;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;

	public class GJCheck extends Sprite 
    {
		public var GameJacketSec : GameJacketAS3 = new GameJacketAS3();
		
		public function GJCheck() 
        {
			// Setup and run GameJacket Security Code
			// GameJacketAS3.as file must be in the same folder as your fla when publishing
			GameJacketSec.setVariables(LoaderInfo(this.root.loaderInfo));
			
			// Add Event Listeners so we know the outcome of the security checks
			GameJacketSec.addEventListener("GameJacketPass", securityOK);
			GameJacketSec.addEventListener("GameJacketFail", securityError);	
			
			securityOK(null); // Dont forget to remove this line before submitting to GJ
		}
		
		private function securityOK(e:Event):void
		{
			// Remove the event listeners
			GameJacketSec.removeEventListener("GameJacketPass", securityOK);
			GameJacketSec.removeEventListener("GameJacketFail", securityError);	
			
			// Start the preloader
			addChild(new Preloader());			
		}
		
		private function securityError(e:Event):void
		{
			// Remove the event listeners
			GameJacketSec.removeEventListener("GameJacketPass", securityOK);
			GameJacketSec.removeEventListener("GameJacketFail", securityError);
			
			// This function will run if the game does not pass the security checks
			var tf : TextField = new TextField();
			tf.text = "An error has occured please contact: you@webmaster.com";
			tf.autoSize = TextFieldAutoSize.CENTER;	
			tf.x = (stage.stageWidth / 2)-(tf.textWidth/2);
			tf.y = stage.stageHeight / 2;
			addChild(tf);			
		}
	}
}