﻿package  
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.DropShadowFilter;
	import flash.geom.Matrix;
	import flash.text.*;
	
	/**
	* ...
	* @author $(DefaultUser)
	*/
	public class Preloader extends Sprite
	{		
		public var _progress : TextField;
		private var _start : SimpleButton;
		
		public function Preloader():void
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void
		{			
			// Make a few UI bits
			makeProgressText();
			makeStartButton();
			
			// Lets add a background of sorts
			var a : Array = [0x5DAAF4,0xA9A9A9];
			var b : Array = [255, 255];
			var c : Array = [0, 255];
			var s : Shape = new Shape();
			var m : Matrix = new Matrix();
			m.createGradientBox(600, 600, Math.PI / 2);
			graphics.beginGradientFill(GradientType.LINEAR, a, b, c, m, SpreadMethod.REFLECT);
			graphics.drawRect(0, 0, 800, 600);
			graphics.endFill();		
			
			// Start to listen for progress while loading the game 
			root.loaderInfo.addEventListener(ProgressEvent.PROGRESS,onLoadingProgress);
			root.loaderInfo.addEventListener(Event.COMPLETE, onLoadingCompleted);
			
			// Checking to see if loading has already completed
			var percent:int = int(root.loaderInfo.bytesLoaded / root.loaderInfo.bytesTotal)
			if (percent==1){ onLoadingCompleted(null); }			
		}
		
		private function makeProgressText() : void
		{
			// The error / loading state text
			var format:TextFormat = new TextFormat();  
			format.color = 0xFFFFFF;
            format.size = 20;	
			_progress = new TextField();
			_progress.defaultTextFormat = format;
			_progress.autoSize = TextFieldAutoSize.CENTER;		
			_progress.x = (stage.stageWidth / 2);
			_progress.y = (stage.stageHeight/2);		
			_progress.selectable = false;			
			this.addChild(_progress);
		}
		
		private function makeStartButton() : void
		{
			var format:TextFormat = new TextFormat();  
			format.color = 0xFFFFFF;
            format.size = 30;
							
			// Up
			var tf : TextField = new TextField();
			tf.defaultTextFormat = format;
			tf.text = "Start";			
			var up : Sprite = new Sprite();
			up.addChild(tf);
			
			// Down
			tf = new TextField();
			tf.defaultTextFormat = format;
			tf.text = "Start";		
			tf.y = 4;
			var down : Sprite = new Sprite();
			down.addChild(tf);
			
			// Hit 
			var hit : Sprite = new Sprite();
			hit.graphics.beginFill(0);
			hit.graphics.drawRect(0, 0, tf.textWidth, tf.textHeight);
			hit.graphics.endFill();
			
			// Over
			format = new TextFormat();  
			format.color = 0xDD0000;
            format.size = 30;
			tf = new TextField();
			tf.defaultTextFormat = format;
			tf.text = "Start";		
			var over : Sprite = new Sprite();
			over.addChild(tf);
			
			_start = new SimpleButton(up, over, down, hit);		
			_start.x = (stage.stageWidth / 2) - 40;
			_start.y = (stage.stageHeight / 2) + 50;	
			_start.visible = false;
			_start.filters = [new DropShadowFilter()];
			addChild(_start);
		}
		
		private function onLoadingProgress(event:Event):void 
		{
			// Update the loading progress text
			var percent:int = int(root.loaderInfo.bytesLoaded / root.loaderInfo.bytesTotal * 100);
			_progress.text = "Loading.. " + percent + "%";
		}
		
		private function onLoadingCompleted(event:Event):void 
		{
			// Remove listeners
			root.loaderInfo.removeEventListener(ProgressEvent.PROGRESS,onLoadingProgress);
			root.loaderInfo.removeEventListener(Event.COMPLETE, onLoadingCompleted);	
			
			// Allow the start button to be pressed
			_start.visible = true;
			_start.addEventListener(MouseEvent.CLICK, startClicked);			
		}
		
		private function startClicked(e:MouseEvent):void 
		{	
			var mainClass:Class = Class(loaderInfo.applicationDomain.getDefinition("Main"));
			var main:DisplayObject = DisplayObject(new mainClass());
			parent.addChild(main);
			parent.removeChild(this);	
		}						
	}
	
}